if GAMESTATE:IsEventMode() and GAMESTATE:IsPlayerEnabled(0) and GAMESTATE:IsPlayerEnabled(1) then
	local d1 = GAMESTATE:GetCurrentSteps(0):GetDifficulty()
	local d2 = GAMESTATE:GetCurrentSteps(1):GetDifficulty()

	local sTable = GAMESTATE:GetCurrentSong():GetStepsByStepsType( "StepsType_Dance_Single" );

	if d1 == 'Difficulty_Challenge' and d2 == 'Difficulty_Challenge' then
		return Def.ActorFrame {
			OnCommand=function(self)
				local r = math.random(1,2)
				GAMESTATE:SetCurrentSteps(0,sTable[r])
				GAMESTATE:SetCurrentSteps(1,sTable[3-r])
				SCREENMAN:SetNewScreen('ScreenGameplay')
			end
		}
	end
end

local root_def = Def.ActorFrame {
	InitCommand=function(self)
		self:sleep(420)
	end,
}

for player_index = 1,2 do
	local player_def = LoadActor('hold.png') .. {
		InitCommand=function(self)
			self:zoomtowidth(0.5 * _screen.w)
			self:zoomtoheight(_screen.h)
			self:x(_screen.cx + (-0.25 + 0.5 * (player_index-1)) * _screen.w)
			self:y(_screen.cy)
			
		end,
		OnCommand=function(self)
			SCREENMAN:GetTopScreen():AddInputCallback(function(event)
				if event.button ~= 'Down' then return end
				
				if event.PlayerNumber ~= 'PlayerNumber_P' .. player_index then return end
				
				if event.type == "InputEventType_FirstPress" then
					self:stoptweening()
					self:linear(0.15):diffusealpha(0)
				elseif event.type == "InputEventType_Release" then
					self:stoptweening()
					self:linear(0.15):diffusealpha(1)
				end
				
			end)
		end,
	}
	
	table.insert(root_def, player_def)
end

return root_def